StringVal="5e-5"
StringTask="read"
#"RTE CoLA SST2 MRPC STSB QQP QNLI MNLI"
model_name="google/electra-large-discriminator"
seeds="1"
for task in $StringTask; do
	for seed in $seeds; do
		for val in $StringVal; do 
		
			echo ${val}
			OutDir="results/finetune/${model_name}/${task}/lr-"
			OutDir+="${val}"
			OutDir+="-seed-${seed}"
			mkdir -p "$OutDir"
			echo ${OutDir}
			CUDA_VISIBLE_DEVICES=0 PYTHONPATH=$PYTHONPATH:./src python ./src/finetune/run_read.py \
			--task_name ${task} \
			--model_name_or_path ${model_name}\
			--train_file ./data/commonlitreadabilityprize/train.csv \
			--validation_file ./data/commonlitreadabilityprize/validation.csv \
			--train_file ./data/commonlitreadabilityprize/train.csv \
			--test_file ./data/commonlitreadabilityprize/test.csv \
			--do_train \
			--do_eval \
			--do_predict \
			--learning_rate $val \
			--warmup_ratio 0.1 \
			--num_train_epochs 3 \
			--max_seq_length 512 \
			--output_dir $OutDir \
			--per_device_eval_batch_size=4 \
			--per_device_train_batch_size=4 \
			--gradient_accumulation_steps 8 \
			--overwrite_output \
			--overwrite_cache \
			--evaluation_strategy epoch \
			--seed ${seed} \
			--save_total_limit 1 \
			--save_steps 10000 |& tee "results/finetune/${model_name}/${task}/${task}_lr${val}_seed${seed}.txt" -i
			#--eval_steps 12 \
			#--logging_steps 12 \
			#--config_name "bert-base-uncased" \
			#--tokenizer_name "bert-base-uncased" \
			#--evaluate_during_training
			#unc-nlp/
		done
	done
done
